<?php
session_start(); // Inicia a sessão PHP

// Verifica se os dados do mapa mental foram enviados via POST
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['mindData'])) {
    $_SESSION['mindData'] = $_POST['mindData']; // Salva os dados da sessão
    exit; // Finaliza a execução após salvar os dados
}

// Recupera os dados da sessão, se existirem
$mindData = isset($_SESSION['mindData']) ? $_SESSION['mindData'] : json_encode([
    'meta' => ['name' => 'Mapa Exemplo', 'author' => 'Seu Nome', 'version' => '1.0'],
    'format' => 'node_array',
    'data' => [
        ['id' => 'root', 'isroot' => true, 'topic' => 'Ideia central'],
        ['id' => 'child1', 'parentid' => 'root', 'topic' => 'Tópico 1'],
        ['id' => 'child2', 'parentid' => 'root', 'topic' => 'Tópico 2'],
    ]
]);

?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SmartSchool Mapa Mental</title>
    <!-- Importando o CSS do jsMind -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/jsmind/style/jsmind.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            height: 100vh;
            background-color: #f4f4f4;
        }

        #jsmind_container {
            width: 90%;
            height: 400px;
            border: 1px solid #ccc;
            background: #fff;
            margin-top: 10px;
        }

        .controls {
            margin-top: 10px;
        }

        .controls button {
            margin-right: 10px;
            padding: 10px 15px;
            font-size: 16px;
            cursor: pointer;
        }

        .color-picker {
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <h1>Mapa Mental Interativo</h1>
    <div class="controls">
        <button onclick="addNode()">Adicionar Nó</button>
        <button onclick="removeNode()">Remover Nó</button>
    </div>

    <!-- Seletor de Cor -->
    <div class="color-picker">
        <label for="colorPicker">Escolher Cor do Nó: </label>
        <input type="color" id="colorPicker">
    </div>

    <div id="jsmind_container"></div>

    <!-- Importando o jsMind -->
    <script src="https://cdn.jsdelivr.net/npm/jsmind/js/jsmind.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jsmind/js/jsmind.draggable.js"></script>

    <script>
        // Recupera os dados do PHP
        const mindData = <?php echo $mindData; ?>;

        // Inicializando o jsMind
        let jm;
        document.addEventListener("DOMContentLoaded", () => {
            const options = {
                container: "jsmind_container",
                theme: "primary",
                editable: true // Permitir edição
            };
            jm = jsMind.show(options, mindData);

            // Adicionar evento de seleção de nó
            jm.add_event_listener(jsMind.event_type.select_node, function(e) {
                const selectedNode = jm.get_selected_node();
                if (selectedNode) {
                    document.getElementById("colorPicker").disabled = false; // Habilitar a seleção de cor
                }
            });
        });

        // Função para adicionar um nó
        function addNode() {
            const selectedNode = jm.get_selected_node();
            if (!selectedNode) {
                alert("Selecione um nó para adicionar um novo nó como filho.");
                return;
            }
            const newId = "node_" + Math.random().toString(36).substr(2, 9); // Gerar ID único
            const newTopic = "Novo Tópico";  // Texto fixo para o novo nó
            jm.add_node(selectedNode.id, newId, newTopic);
            saveMindData(); // Salva os dados após a alteração
        }

        // Função para remover o nó selecionado
        function removeNode() {
            const selectedNode = jm.get_selected_node();
            if (!selectedNode) {
                alert("Selecione um nó para remover.");
                return;
            }
            if (selectedNode.isroot) {
                alert("Não é possível remover o nó raiz.");
                return;
            }
            jm.remove_node(selectedNode.id);
            saveMindData(); // Salva os dados após a alteração
        }

        // Função para trocar a cor do nó selecionado
        document.getElementById("colorPicker").addEventListener("input", function() {
            const selectedNode = jm.get_selected_node();
            if (!selectedNode) {
                alert("Selecione um nó para alterar a cor.");
                return;
            }
            const color = this.value;  // Pega a cor selecionada
            jm.set_node_color(selectedNode.id, color);  // Altera a cor do nó
            saveMindData(); // Salva os dados após a alteração
        });

        // Função para salvar os dados do mapa mental na sessão PHP via AJAX
        function saveMindData() {
            const mindData = jm.get_data();
            const xhr = new XMLHttpRequest();
            xhr.open("POST", "", true); // Requisição POST para o próprio arquivo
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.send("mindData=" + encodeURIComponent(JSON.stringify(mindData))); // Envia os dados em formato JSON
        }
    </script>
</body>
</html>
